local assets=
{
	Asset("ANIM", "anim/cr_unit.zip"),
	Asset("ANIM", "anim/esctemplate_ast.zip"),
	Asset("ANIM", "anim/tobiichiorigami.zip"),
	Asset("ATLAS", "images/inventoryimages/cr_unit.xml"),
	
	
}
local isDropped,isWeared
local function saniup(inst)
	if inst.isWeared 
	then
		inst.components.equippable.dapperness = -1
	end
end

local function onequip(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_hat", "cr_unit", "swap_hat")
        owner.AnimState:Show("HAT")
        owner.AnimState:Show("HAT_HAIR")
		inst.components.talker:Say("识别，AST鸢一折纸,基础显现装置启动认证")
		owner.AnimState:SetBuild("esctemplate_ast")
		owner.components.combat:GetAttacked(nil, 20)
		inst.isWeared = true
		inst.isDropped = false
		owner.components.health.maxhealth = 300
		owner.components.health:DoDelta(0)
		owner.components.combat.damagemultiplier = 1.2
		owner.healthtask = owner:DoPeriodicTask(1, function()
		owner.components.health:DoDelta(.7, true)
		end)
		owner.components.locomotor.walkspeed = 14
	    owner.components.locomotor.runspeed = 16
		
		saniup(inst)
end

local function onunequip(inst, owner) 
        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
		owner.AnimState:SetBuild("tobiichiorigami")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")
		inst.isWeared = false
		inst.isDropped = false
		owner.components.health.maxhealth = 150
		owner.components.combat.damagemultiplier = 0.8
		owner.components.locomotor.walkspeed = 6
	    owner.components.locomotor.runspeed = 8.5
		if owner.healthtask then
        owner.healthtask:Cancel()
        owner.healthtask = nil
	end
        owner.components.health:DoDelta(0)
		owner.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE*1)
		saniup(inst)
end
local function ondrop(inst)
	inst.isDropped = true
	inst.isWeared = false
	
	saniup(inst)
end
local function fn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	inst.entity:AddNetwork()
    
    inst:AddTag("hat")
    
	inst.isWeared = false
	inst.isDropped = false
	
    anim:SetBank("cr_unit")
    anim:SetBuild("cr_unit")
    anim:PlayAnimation("idle")    
        
    inst:AddComponent("inspectable")

	if not TheWorld.ismastersim then
        return inst
    end
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/cr_unit.xml"
    inst:AddComponent("armor")
	inst.components.armor:InitCondition(100000,.2)
    
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
        inst:AddComponent("talker")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	inst.components.inventoryitem:SetOnDroppedFn( ondrop )
		inst.components.inventoryitem.onputininventoryfn = function(inst, player)
		local owner = inst.components.inventoryitem:GetGrandOwner()
		if player.components.inventory and player.prefab ~= "tobiichiorigami" then 
			inst:DoTaskInTime(0.1, function()
			
			player.components.inventory:DropItem(inst)
			inst.components.talker:Say("我不是AST成员")
			end)
		--If it's in a container		
		elseif player.components.container and owner.prefab ~= "tobiichiorigami" then 
			inst:DoTaskInTime(0.1, function()
			
			player.components.container:DropItem(inst)
			inst.components.talker:Say("我塞不进包里")
			end)
		end
	end
	inst:DoPeriodicTask(1, function(inst,owner)
	local owner = inst.components.inventoryitem:GetGrandOwner()
	if owner ~= nil then
	if owner.components.sanity.current<=50
	then
	
            local target = GetPlayer()
            local item = target.components.inventory:GetEquippedItem(EQUIPSLOTS.HEAD)
            if inst == item then
                target.components.inventory:GiveItem(item)
            end
            inst:RemoveComponent("equippable")
	
	--
	end
	end
	end)
	inst:ListenForEvent("phasechanged", function() saniup(inst) end, TheWorld)
	
    return inst
end
return Prefab( "cr_unit", fn, assets) 
